/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275rr;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8275rr.BoxInfo;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class TrapReceiversCreate
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8275rr.Resources");
    private static final int RASID = 19;
    private static final int RASSUB = 9;
    DestinationPropBook myBook;
    JdmBrowser browser;
    GenModel device_Model;
    NavigationContext myContext;
    BoxInfo boxInfo;
    MessageBox messageToUser;
    String errorMsg;
    boolean loggingOn = false;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        Hashtable hashtable = jDMWizardInfo.getItems();
        hashtable.put("newUnit", new Integer(1));
        hashtable.put("newIpAddr", new IPAddress("0.0.0.0"));
        hashtable.put("newCommunity", "");
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl = true;
        GenModel genModel = null;
        ModelInfo modelInfo = null;
        Hashtable hashtable = null;
        String string = null;
        IPAddress iPAddress = null;
        Integer n = null;
        String string2 = "proceed";
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, this, string2, "Can't get browser- can't proceed with create");
            }
            bl = false;
        }
        if (bl) {
            if (this.browser.getIsApplication()) {
                this.loggingOn = Log.getLog().getLoggingState();
            }
            if (RAS.isEnabled(19, 9)) {
                RAS.enter(19, 9, this, string2);
            }
            hashtable = jDMWizardInfo.getItems();
            genModel = jDMWizardInfo.getModel();
            try {
                n = (Integer)hashtable.get("newUnit");
                iPAddress = (IPAddress)hashtable.get("newIpAddr");
                string = (String)hashtable.get("newCommunity");
                if (n != 1) {
                    if (RAS.isEnabled(19, 9)) {
                        RAS.trace(19, 9, this, string2, "Invalid unit selected.unit = " + n);
                    }
                    this.errorMsg = new String("WZ_invalidUnit");
                    bl = false;
                } else if (string.trim().length() == 0) {
                    if (RAS.isEnabled(19, 9)) {
                        RAS.trace(19, 9, this, string2, "Missing community name = ");
                    }
                    this.errorMsg = new String("WZ_missingInfo");
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 9)) {
                    RAS.trace(19, 9, this, string2, "Exception getting user data- can't create row");
                }
                RAS.logException(19, 9, this, string2, exception);
                this.errorMsg = new String("WZ_missingInfo");
                bl = false;
            }
        }
        if (bl) {
            modelInfo = new ModelInfo();
            modelInfo.add("Index.Unit", n);
            modelInfo.add("Index.IpAddr", iPAddress);
            try {
                modelInfo = genModel.getInfo("Panel", "default", modelInfo);
                if (modelInfo.get("Panel.Community") instanceof String) {
                    if (RAS.isEnabled(19, 9)) {
                        RAS.trace(19, 9, this, string2, "Trap Receiver Address already exists");
                    }
                    this.errorMsg = new String("TC_already exists");
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 9)) {
                    RAS.trace(19, 9, this, string2, "unexcepted bypassable exception");
                }
                RAS.logException(19, 9, this, string2, exception);
            }
            if (RAS.isEnabled(19, 9)) {
                RAS.exit(19, 9, this, string2);
            }
        }
        if (bl) {
            modelInfo = new ModelInfo();
            modelInfo.add("Index.Unit", n);
            modelInfo.add("Index.IpAddr", iPAddress);
            modelInfo.add("Panel.Community", (Serializable)((Object)string));
            try {
                modelInfo = genModel.setInfo("Panel", modelInfo);
                Serializable serializable = modelInfo.get("Panel.Community");
                if (serializable instanceof SpecialValue) {
                    bl = false;
                    this.errorMsg = serializable instanceof Timeout ? new String("WZ_timeout") : new String("WZ_badSet");
                    if (RAS.isEnabled(19, 9)) {
                        RAS.trace(19, 9, this, string2, "Set rejected by device - Special Value = " + serializable);
                    }
                }
            }
            catch (Exception exception) {
                bl = false;
                this.errorMsg = new String("WZ_badSet");
                if (RAS.isEnabled(19, 9)) {
                    RAS.trace(19, 9, this, string2, "Exception setting trap Receiver Create data");
                }
                RAS.logException(19, 9, this, string2, exception);
            }
        }
        if (!bl && this.browser != null) {
            this.browser.displayMsg(TrapReceiversCreate.getNLSString(this.errorMsg));
            this.messageToUser = new MessageBox(this.browser.getFrame(), TrapReceiversCreate.getNLSString("TC_error"), TrapReceiversCreate.getNLSString(this.errorMsg), true);
        }
        return bl;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private void printMsg(String string) {
        if (RAS.isEnabled(19, 9)) {
            RAS.trace(19, 9, this, "***", string);
        }
    }

    private void printExcept(Exception exception, String string) {
        RAS.logException(19, 9, this, "***", exception);
        if (RAS.isEnabled(19, 9) && string != null) {
            RAS.trace(19, 9, this, "***", string);
        }
    }
}

